package gov.va.med.mhv.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "IPA_CRITERIA")
public class InPersonAuthenticationCriteria extends AbstractBaseEntity {

	private static final long serialVersionUID = -3833108733685880260L;

	@Id
	@Column(name = "ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "FIRST_NAME")
	private String firstName;

	@Column(name = "MIDDLE_NAME")
	private String middleName;

	@Column(name = "LAST_NAME")
	private String lastName;

	@Column(name = "FIRST_PLUS_FOUR")
	private String firstPlusFour;

	@Column(name = "SSN")
	private String ssn;

	@Column(name = "USER_NAME")
	private String userName;

	@Column(name = "MHV_ID")
	private String mhvId;

	@Column(name = "EMAIL")
	private String email;

	@Column(name = "DATE_OF_BIRTH")
	@Temporal(TemporalType.TIMESTAMP)
	private Date dateOfBirth;

	@Column(name = "PATIENT_AT_FACILITY")
	private Long treatingFacilityId;

	@Column(name = "IPA_FACILITY_INFO")
	private Long authenticatingFacilityInfoId;

	@Column(name = "IPA_FROM_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date fromAuthenticationDate;

	@Column(name = "IPA_TO_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date toAuthenticationDate;

	@Column(name = "STAT_PEND_AUTH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPendingAuthentication;

	@Column(name = "STAT_PEND_FAIL", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPendingFailed;

	@Column(name = "STAT_PEND_MISMATCH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPendingDataMismatch;

	@Column(name = "STAT_PEND_UNAUTH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPendingUnauthentication;

	@Column(name = "STAT_AUTH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusAuthenticated;

	@Column(name = "STAT_UNAUTH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusUnauthenticated;

	@Column(name = "STAT_IN_PROCESS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusInProcess;

	@Column(name = "STAT_PREREQ_COMPLETE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPrerequisitesComplete;

	@Column(name = "STAT_MATCH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusMatched;

	@Column(name = "STAT_UNMATCH", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusUnmatched;

	@Column(name = "STAT_COR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusCorrelated;

	@Column(name = "STAT_PEND_COR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusPendingCorrelation;

	@Column(name = "STAT_PEND_UNCOR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusUncorrelated;

	@Column(name = "STAT_FAILED_COR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusFailedCorrelation;

	@Column(name = "STAT_FAILED_UNCOR", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusFailedUncorrelation;

	@Column(name = "STAT_COR_INVALID", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean statusCorrelationInvalid;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstPlusFour() {
		return firstPlusFour;
	}

	public void setFirstPlusFour(String firstPlusFour) {
		this.firstPlusFour = firstPlusFour;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getMhvId() {
		return mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Date getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public Long getTreatingFacilityId() {
		return treatingFacilityId;
	}

	public void setTreatingFacilityId(Long treatingFacilityId) {
		this.treatingFacilityId = treatingFacilityId;
	}

	public Long getAuthenticatingFacilityInfoId() {
		return authenticatingFacilityInfoId;
	}

	public void setAuthenticatingFacilityInfoId(Long authenticatingFacilityInfoId) {
		this.authenticatingFacilityInfoId = authenticatingFacilityInfoId;
	}

	public Date getFromAuthenticationDate() {
		return fromAuthenticationDate;
	}

	public void setFromAuthenticationDate(Date fromAuthenticationDate) {
		this.fromAuthenticationDate = fromAuthenticationDate;
	}

	public Date getToAuthenticationDate() {
		return toAuthenticationDate;
	}

	public void setToAuthenticationDate(Date toAuthenticationDate) {
		this.toAuthenticationDate = toAuthenticationDate;
	}

	public Boolean getStatusPendingAuthentication() {
		return statusPendingAuthentication;
	}

	public void setStatusPendingAuthentication(Boolean statusPendingAuthentication) {
		this.statusPendingAuthentication = statusPendingAuthentication;
	}

	public Boolean getStatusPendingFailed() {
		return statusPendingFailed;
	}

	public void setStatusPendingFailed(Boolean statusPendingFailed) {
		this.statusPendingFailed = statusPendingFailed;
	}

	public Boolean getStatusPendingDataMismatch() {
		return statusPendingDataMismatch;
	}

	public void setStatusPendingDataMismatch(Boolean statusPendingDataMismatch) {
		this.statusPendingDataMismatch = statusPendingDataMismatch;
	}

	public Boolean getStatusPendingUnauthentication() {
		return statusPendingUnauthentication;
	}

	public void setStatusPendingUnauthentication(Boolean statusPendingUnauthentication) {
		this.statusPendingUnauthentication = statusPendingUnauthentication;
	}

	public Boolean getStatusAuthenticated() {
		return statusAuthenticated;
	}

	public void setStatusAuthenticated(Boolean statusAuthenticated) {
		this.statusAuthenticated = statusAuthenticated;
	}

	public Boolean getStatusUnauthenticated() {
		return statusUnauthenticated;
	}

	public void setStatusUnauthenticated(Boolean statusUnauthenticated) {
		this.statusUnauthenticated = statusUnauthenticated;
	}

	public Boolean getStatusInProcess() {
		return statusInProcess;
	}

	public void setStatusInProcess(Boolean statusInProcess) {
		this.statusInProcess = statusInProcess;
	}

	public Boolean getStatusPrerequisitesComplete() {
		return statusPrerequisitesComplete;
	}

	public void setStatusPrerequisitesComplete(Boolean statusPrerequisitesComplete) {
		this.statusPrerequisitesComplete = statusPrerequisitesComplete;
	}

	public Boolean getStatusMatched() {
		return statusMatched;
	}

	public void setStatusMatched(Boolean statusMatched) {
		this.statusMatched = statusMatched;
	}

	public Boolean getStatusUnmatched() {
		return statusUnmatched;
	}

	public void setStatusUnmatched(Boolean statusUnmatched) {
		this.statusUnmatched = statusUnmatched;
	}

	public Boolean getStatusCorrelated() {
		return statusCorrelated;
	}

	public void setStatusCorrelated(Boolean statusCorrelated) {
		this.statusCorrelated = statusCorrelated;
	}

	public Boolean getStatusPendingCorrelation() {
		return statusPendingCorrelation;
	}

	public void setStatusPendingCorrelation(Boolean statusPendingCorrelation) {
		this.statusPendingCorrelation = statusPendingCorrelation;
	}

	public Boolean getStatusUncorrelated() {
		return statusUncorrelated;
	}

	public void setStatusUncorrelated(Boolean statusUncorrelated) {
		this.statusUncorrelated = statusUncorrelated;
	}

	public Boolean getStatusFailedCorrelation() {
		return statusFailedCorrelation;
	}

	public void setStatusFailedCorrelation(Boolean statusFailedCorrelation) {
		this.statusFailedCorrelation = statusFailedCorrelation;
	}

	public Boolean getStatusFailedUncorrelation() {
		return statusFailedUncorrelation;
	}

	public void setStatusFailedUncorrelation(Boolean statusFailedUncorrelation) {
		this.statusFailedUncorrelation = statusFailedUncorrelation;
	}

	public Boolean getStatusCorrelationInvalid() {
		return statusCorrelationInvalid;
	}

	public void setStatusCorrelationInvalid(Boolean statusCorrelationInvalid) {
		this.statusCorrelationInvalid = statusCorrelationInvalid;
	}

}
